package com.foobar.dragbug;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.part.NullEditorInput;

public class OpenEditorAction extends Action {

	private final IWorkbenchWindow window;
	private final int instanceNum = 0;
	private final String editorId;

	public OpenEditorAction(IWorkbenchWindow window, String label, String editorId) {
		this.window = window;
		this.editorId = editorId;
		setText(label);
		// The id is used to refer to the action in a menu or toolbar
		setId(ICommandIds.CMD_OPEN);
		// Associate the action with a pre-defined command, to allow key bindings.
		setActionDefinitionId(ICommandIds.CMD_OPEN);
		setImageDescriptor(com.foobar.dragbug.Activator.getImageDescriptor("/icons/sample2.gif"));
	}

	@Override
	public void run() {
		if (this.window != null) {
			try {
				this.window.getActivePage().openEditor(new NullEditorInput(), this.editorId);
			} catch (PartInitException e) {
				MessageDialog.openError(this.window.getShell(), "Error", "Error opening view:" + e.getMessage());
			}
		}
	}
}
